#include "sprite_manager.h"
#include "global_manager.h"
#include <sms.h>

// Private functions.
static void engine_sprite_draw_enemy(unsigned char i, unsigned char x, unsigned char y);
static void engine_sprite_load_tiles(unsigned char* tiles, int start, int count);
static void engine_sprite_show_tiles(unsigned char i, unsigned char x, unsigned char y, unsigned char n);

unsigned char engine_sprite_target_tiles[] =
{
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x2A,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9C, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x54,
0x00, 0x00, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x9C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
unsigned char engine_sprite_bullets_tiles[] =
{
// Bullet #1.	
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x3F, 0x00, 0x3F, 0x20, 0x20, 0x00, 0x20, 0x20, 0x20, 0x00, 0x20, 0x20, 0x20, 0x00, 0x20, 0x20, 0x20, 0x00, 0x20, 0x20, 0x20, 0x00, 0x20,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFC, 0x00, 0xFC, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x04,
0x20, 0x20, 0x00, 0x20, 0x20, 0x20, 0x00, 0x20, 0x20, 0x20, 0x00, 0x20, 0x20, 0x20, 0x00, 0x20, 0x20, 0x20, 0x00, 0x20, 0x3F, 0x3F, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x04, 0xFC, 0xFC, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// Bullet #2.
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x00, 0x1F, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0x00, 0xF8, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08,
0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x1F, 0x1F, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0xF8, 0xF8, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// Bullet #3.
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x00, 0x0F, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0x00, 0xF0, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10,
0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x0F, 0x0F, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0xF0, 0xF0, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// Bullet #4.
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00, 0x07, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x04,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xE0, 0x00, 0xE0, 0x20, 0x20, 0x00, 0x20, 0x20, 0x20, 0x00, 0x20,
0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x04, 0x07, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x20, 0x20, 0x00, 0x20, 0x20, 0x20, 0x00, 0x20, 0xE0, 0xE0, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// Bullet #5.
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x02, 0x02, 0x00, 0x02,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0x00, 0xC0, 0x40, 0x40, 0x00, 0x40,
0x02, 0x02, 0x00, 0x02, 0x03, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x40, 0x40, 0x00, 0x40, 0xC0, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// Bullet #6.
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x80,
0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x80, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

unsigned char engine_sprite_enemies_tiles[] =
{
// Enemy #1. (8x8)
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x0C, 0x03, 0x07, 0x03, 0x08,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x30, 0x00, 0x20, 0x00, 0x30, 0xC0, 0xE0, 0xC0, 0x10,
0x02, 0x06, 0x02, 0x09, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x40, 0x60, 0x40, 0x90, 0x00, 0x20, 0x00, 0x30, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// Enemy #2. (16x16)
0x00, 0x00, 0x00, 0xC0, 0x00, 0x40, 0x00, 0xE0, 0x00, 0x40, 0x00, 0xE0, 0x00, 0x60, 0x00, 0xF0, 0x00, 0x20, 0x00, 0xB0, 0x00, 0x50, 0x00, 0xD9, 0x00, 0x60, 0x00, 0xEA, 0x00, 0x11, 0x00, 0x77,
0x00, 0x00, 0x00, 0x03, 0x00, 0x02, 0x00, 0x07, 0x00, 0x02, 0x00, 0x07, 0x00, 0x06, 0x00, 0x0F, 0x00, 0x04, 0x00, 0x0D, 0x00, 0x0A, 0x00, 0x9B, 0x00, 0x06, 0x00, 0x57, 0x00, 0x88, 0x00, 0xEE,
0x00, 0x11, 0x00, 0x77, 0x00, 0x60, 0x00, 0xEB, 0x00, 0x50, 0x00, 0xD9, 0x00, 0x20, 0x00, 0xB0, 0x00, 0x60, 0x00, 0xF0, 0x00, 0x40, 0x00, 0xE0, 0x00, 0x40, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xC0,
0x00, 0x88, 0x00, 0xEE, 0x00, 0x06, 0x00, 0xD7, 0x00, 0x0A, 0x00, 0x9B, 0x00, 0x04, 0x00, 0x0D, 0x00, 0x06, 0x00, 0x0F, 0x00, 0x02, 0x00, 0x07, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x03,
// Enemy #3. (32x32)	1. TOP LEFT
0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x30, 0x00, 0xFC, 0x00, 0x30, 0x00, 0xFC, 0x00, 0x30, 0x00, 0xFC, 0x00, 0x30, 0x00, 0xFC, 0x00, 0x3C, 0x00, 0xFF, 0x00, 0x3C, 0x00, 0xFF,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x0C, 0x00, 0xCF, 0x00, 0x0C, 0x00, 0xCF, 0x00, 0x33, 0x00, 0xF3, 0x00, 0x33, 0x00, 0xF3, 0x00, 0x3C, 0x00, 0xFC, 0x00, 0x3C, 0x00, 0xFC, 0x00, 0x03, 0x00, 0x3F, 0x00, 0x03, 0x00, 0x3F,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xCC, 0x00, 0x00, 0x00, 0xCC, 0x00, 0x03, 0x00, 0x3F, 0x00, 0x03, 0x00, 0x3F,
// Enemy #3. (32x32)	2. BOT LEFT
0x00, 0x03, 0x00, 0x3F, 0x00, 0x03, 0x00, 0x3F, 0x00, 0x3C, 0x00, 0xFC, 0x00, 0x3C, 0x00, 0xFC, 0x00, 0x33, 0x00, 0xF3, 0x00, 0x33, 0x00, 0xF3, 0x00, 0x0C, 0x00, 0xCF, 0x00, 0x0C, 0x00, 0xCF,
0x00, 0x03, 0x00, 0x3F, 0x00, 0x03, 0x00, 0x3F, 0x00, 0x00, 0x00, 0xCF, 0x00, 0x00, 0x00, 0xCF, 0x00, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x3C, 0x00, 0xFF, 0x00, 0x3C, 0x00, 0xFF, 0x00, 0x30, 0x00, 0xFC, 0x00, 0x30, 0x00, 0xFC, 0x00, 0x30, 0x00, 0xFC, 0x00, 0x30, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xF0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// Enemy #3. (32x32)	3. TOP RIGHT
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x0C, 0x00, 0x3F, 0x00, 0x0C, 0x00, 0x3F, 0x00, 0x0C, 0x00, 0x3F, 0x00, 0x0C, 0x00, 0x3F, 0x00, 0x3C, 0x00, 0xFF, 0x00, 0x3C, 0x00, 0xFF,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0x33, 0x00, 0xC0, 0x00, 0xFC, 0x00, 0xC0, 0x00, 0xFC,
0x00, 0x30, 0x00, 0xF3, 0x00, 0x30, 0x00, 0xF3, 0x00, 0xCC, 0x00, 0xCF, 0x00, 0xCC, 0x00, 0xCF, 0x00, 0x3C, 0x00, 0x3F, 0x00, 0x3C, 0x00, 0x3F, 0x00, 0xC0, 0x00, 0xFC, 0x00, 0xC0, 0x00, 0xFC,
// Enemy #3. (32x32)	4. BOT RIGHT
0x00, 0xC0, 0x00, 0xFC, 0x00, 0xC0, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xC0, 0x00, 0xFC, 0x00, 0xC0, 0x00, 0xFC, 0x00, 0x3C, 0x00, 0x3F, 0x00, 0x3C, 0x00, 0x3F, 0x00, 0xCC, 0x00, 0xCF, 0x00, 0xCC, 0x00, 0xCF, 0x00, 0x30, 0x00, 0xF3, 0x00, 0x30, 0x00, 0xF3,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x3C, 0x00, 0xFF, 0x00, 0x3C, 0x00, 0xFF, 0x00, 0x0C, 0x00, 0x3F, 0x00, 0x0C, 0x00, 0x3F, 0x00, 0x0C, 0x00, 0x3F, 0x00, 0x0C, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x0F,
};

unsigned char engine_sprite_explodes_tiles[] =
{
// Explode #1.
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x1F, 0x07, 0x00, 0x00, 0x3F, 0x0F, 0x00, 0x07, 0x7F, 0x1F, 0x00, 0x07, 0x7F, 0x3F, 0x00, 0x0F,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0xF0, 0xE0, 0x00, 0x00, 0xF8, 0xF0, 0x00, 0x80, 0xF8, 0xF0, 0x00, 0x80, 0xFC, 0xF8, 0x00, 0x80,
0x3F, 0x1F, 0x00, 0x0F, 0x3F, 0x1F, 0x00, 0x0F, 0x3F, 0x3F, 0x00, 0x0F, 0x3F, 0x1F, 0x00, 0x01, 0x0F, 0x07, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0xFC, 0xFC, 0x00, 0x00, 0xFC, 0xF8, 0x00, 0x00, 0xF8, 0xF0, 0x00, 0xE0, 0xF8, 0xE0, 0x00, 0x80, 0xF0, 0xE0, 0x00, 0x80, 0xC0, 0xC0, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// Explode #2.
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x03, 0x00, 0x00, 0x1F, 0x0F, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0xFF, 0x00, 0x3F,
0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0xF0, 0xC0, 0x00, 0x00, 0xF8, 0xE0, 0x00, 0x80, 0xFC, 0xF8, 0x00, 0xE0, 0xFC, 0xF8, 0x00, 0xE0, 0xFE, 0xFC, 0x00, 0xE0, 0xFF, 0xFC, 0x00, 0xC0,
0xFF, 0x7F, 0x00, 0x1F, 0xFF, 0x7F, 0x00, 0x1F, 0xFF, 0x7F, 0x00, 0x1F, 0xFF, 0x7F, 0x00, 0x1F, 0x7F, 0x3F, 0x00, 0x01, 0x3F, 0x0F, 0x00, 0x00, 0x3F, 0x07, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00,
0xFF, 0xFE, 0x00, 0xE0, 0xFF, 0xFE, 0x00, 0xF0, 0xFE, 0xFC, 0x00, 0xF8, 0xFC, 0xFC, 0x00, 0xF0, 0xFC, 0xF8, 0x00, 0xC0, 0xF8, 0xE0, 0x00, 0x00, 0xE0, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00,
// Explode #3.
0x01, 0x00, 0x00, 0x00, 0x07, 0x01, 0x00, 0x00, 0x3F, 0x07, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0x00, 0x3F,
0x80, 0x00, 0x00, 0x00, 0xE0, 0x80, 0x00, 0x00, 0xF8, 0xE0, 0x00, 0x00, 0xF8, 0xF0, 0x00, 0xC0, 0xFC, 0xF0, 0x00, 0xE0, 0xFC, 0xF8, 0x00, 0xE0, 0xFE, 0xFC, 0x00, 0xC0, 0xFF, 0xFC, 0x00, 0xC0,
0xFC, 0xFC, 0x00, 0x1F, 0xFC, 0x7C, 0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0x7F, 0x00, 0x1F, 0xFF, 0x7F, 0x00, 0x07, 0xFF, 0x3F, 0x00, 0x00, 0x7F, 0x0F, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00,
0xFF, 0xFE, 0x00, 0xE0, 0xFF, 0xFE, 0x00, 0xF0, 0xFE, 0xFC, 0x00, 0xF0, 0xFC, 0xFC, 0x00, 0xF0, 0xFC, 0xF8, 0x00, 0xE0, 0xFC, 0xF0, 0x00, 0xC0, 0xF0, 0xE0, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00,
// Explode #4.
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x3F, 0x01, 0x00, 0x00, 0x7F, 0x3F, 0x00, 0x00, 0x7F, 0x7F, 0x00, 0x10, 0x7F, 0x7F, 0x00, 0x10, 0x7F, 0x7F, 0x07, 0x00,
0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0xE0, 0xC0, 0x00, 0x00, 0xF0, 0xE0, 0x00, 0x00, 0xF0, 0xE0, 0x00, 0x00, 0xF8, 0xF0, 0x00, 0x00, 0xFC, 0xF8, 0x00, 0x00, 0xFC, 0xF8, 0xE0, 0x00,
0xFE, 0x7E, 0x06, 0x01, 0x7E, 0x3E, 0x06, 0x01, 0x7F, 0x3F, 0x03, 0x00, 0x7F, 0x3F, 0x01, 0x00, 0x7F, 0x1F, 0x00, 0x00, 0x1F, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
0x7E, 0x78, 0x60, 0x80, 0x7C, 0x70, 0x60, 0x80, 0x78, 0x70, 0x60, 0x80, 0x78, 0x70, 0x60, 0x80, 0xF8, 0xF0, 0x00, 0x00, 0xF0, 0xE0, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

void engine_sprite_manager_load()
{
	engine_sprite_load_tiles(engine_sprite_target_tiles, TARGET, 4);

	engine_sprite_load_tiles(engine_sprite_bullets_tiles, BULLETS, 24);
	engine_sprite_load_tiles(engine_sprite_enemies_tiles,  ENEMIES,  24);
	engine_sprite_load_tiles(engine_sprite_explodes_tiles,  EXPLODES,  16);
}
void engine_sprite_manager_draw_target(unsigned char x, unsigned char y)
{
	engine_sprite_show_tiles(0, x, y, TARGET);
}
void engine_sprite_manager_draw_bullet(unsigned char i, unsigned char x, unsigned char y, unsigned char n)
{
	unsigned char index = 0;
	if (0 != n)
	{
		index = (n - 1) * 4 + BULLETS;
	}

	engine_sprite_show_tiles(i, x, y, index);
}

void engine_sprite_manager_draw_enemies(unsigned char i, unsigned char x, unsigned char y, unsigned char n)
{
	if (0 == n || 4 == n || 6 == n)
	{
		// NONE.
		engine_sprite_draw_enemy(i, x, y);
	}
	else if (1 == n)
	{
		// SMALL.
		engine_sprite_show_tiles(i, x+8, y+8, ENEMY8);
	}
	else if (2 == n)
	{
		// MEDIUM.
		engine_sprite_show_tiles(i, x+8, y+8, ENEMY16);
	}
	else if (3 == n || 5 == n || 7 == n)
	{
		// LARGE.
		engine_sprite_show_tiles(i+0, x+0, y+0, ENEMY32);
		engine_sprite_show_tiles(i+4, x+0, y+16, ENEMY32+4);
		engine_sprite_show_tiles(i+8, x+16, y+0, ENEMY32+8);
		engine_sprite_show_tiles(i+12, x+16, y+16, ENEMY32+12);
	}
}
void engine_sprite_manager_clear()
{
	unsigned char index;
	for (index = 0; index < SPRITES; index++)
	{
		engine_sprite_show_tiles(index, 0, 0, 0);
	}
}
static void engine_sprite_draw_enemy(unsigned char i, unsigned char x, unsigned char y)
{
	engine_sprite_show_tiles(i+0, x+0, y+0, 0);
	engine_sprite_show_tiles(i+4, x+0, y+16, 0);
	engine_sprite_show_tiles(i+8, x+16, y+0, 0);
	engine_sprite_show_tiles(i+12, x+16, y+16, 0);
}

void engine_sprite_manager_draw_explode(unsigned char i, unsigned char x, unsigned char y, unsigned char n)
{
	unsigned char index = 0;
	if (0 != n)
	{
		index = (n - 1) * 4 + EXPLODES;
	}

	engine_sprite_show_tiles(i, x+8, y+8, index);
}
static void engine_sprite_load_tiles(unsigned char* tiles, int start, int count)
{
	// tiles	array
	// start	tilemap viewer
	// count	how many tiles
	// bpp		4 bits per pixel
	load_tiles(tiles, start, count, 4);			// SMS.
}

static void engine_sprite_show_tiles(unsigned char i, unsigned char x, unsigned char y, unsigned char n)
{
	// i	priority
	// n	tileview
	set_sprite(i+0, x+0, y+0, n+0);
	set_sprite(i+1, x+8, y+0, n+1);
	set_sprite(i+2, x+0, y+8, n+2);
	set_sprite(i+3, x+8, y+8, n+3);
}
